#pragma once

#include <vector>
#include <string>
#include <DWLDialogo.h>
#include <DWLEditBox.h>
#include <DWLComboBox.h>
#include <DWLListView.h>
#include <DWLMenu.h>
#include <DWLArchivoBinario.h>
//#include "ArchivF.h"                       // Clase para guardar datos de los archivos
 


class DatosArchivo {
public :
				DatosArchivo(void) { };
/*				DatosArchivo(const char *Pt) { 
					Path = Pt; 
					for (unsigned int i = Path.size() -1; i != -1; i--) {
						if (Path[i] == '\\') {
							PathDest = Path.substr(i, Path.size() - i);
							break;
						}
					}
				};*/
				DatosArchivo(const TCHAR *Pt, const TCHAR *Source) { 
					unsigned int tam = 0;
					if (Source != NULL) tam = DWLStrLen(Source);
					Path = Pt; 
					if (Source == 0) {
						for (unsigned int i = Path.Tam() -1; i != -1; i--) {
							if (Path[i] == TEXT('\\')) {
								PathDest = Path.SubStr(i, Path.Tam() - i);
								break;
							}
						}
					}
					else {
						PathDest = TEXT("\\");
						PathDest += &Pt[tam];
					}
				}

			   ~DatosArchivo(void) { 
			    };

 DWL::DWLString	Path;                        // Path origen
 DWL::DWLString	PathDest;                    // Path Destino

};

class ContenedorBinario {
public :
				ContenedorBinario(void) { _Longitud = 0; _Datos = NULL; };
	           ~ContenedorBinario(void) { if (_Datos != NULL) delete [] _Datos; };
 void			AgregarParte(const char *NuevaParte, const size_t LongitudParte) {
					char *NuevosDatos = new char [_Longitud + LongitudParte];
					if (_Datos != NULL) {
						CopyMemory(NuevosDatos, _Datos, _Longitud);
						delete [] _Datos;
					}
					CopyMemory(&NuevosDatos[_Longitud], NuevaParte, LongitudParte);
					_Datos = NuevosDatos;
					_Longitud += LongitudParte;
			    };
 char	        operator() (void) {
					return _Datos[0];
				};
 size_t		   &Longitud(void) {
					return _Longitud;
				};
 void			Borrar(void) {
					_Longitud = 0;
					if (_Datos != NULL) delete [] _Datos;
					_Datos = NULL;
				};
 char         *_Datos;
 size_t		   _Longitud;
};


class VentanaMain : public DWL::Ventanas::DWLDialogo {																	  //
public:																										  // Funciones y variables publicas
							VentanaMain(void);                                                                // Constructor
                           ~VentanaMain(void);                                                                // Destructor
 void						Crear(void);                                                                      // Funcion para crear el dialogo
 BOOL						Evento_Comando(const int cID, const UINT CodigoNotificacion, HWND hWndControl);   // Funcion para obtener los mensajes de notificacion de los botones
 BOOL		                Evento_ListView_Mouse_Click(const UINT Boton, const int cX, const int cY, const UINT IDListView);
 BOOL						Evento_ListView_LabelEdit_Fin(DWL::Controles::DWLListView_TerminarLabelEdit *Edicion, const UINT IDListView);
 BOOL						Evento_Cerrar(void);                                                              // Al cerrar
 const int					Comprimir2(DWL::Archivos::DWLArchivoBinario &Origen, ContenedorBinario &Destino);
private:																									  // Funciones y variables privadas
 void                       GuardarProyecto(void);
 void                       AbrirProyecto(void);
 void						MirarTXTClave(HKEY Root, TCHAR *Key, TCHAR *Nombre, TCHAR *Resultado, DWORD ResTam); // Funcion para obener datos del registro de windows
 void						CrearInst(void);                                                                  // Funcion que crea la instalacion
 bool						Filtro(const TCHAR *Text);                                                         // Funcion para mirar caractres o validos en el Directorio
 void						MirarDirs(void);                                                                  // Funcion para enumerar los directorios
 void						Borrar(void);                                                                     // Funcion para borrar un item
 void						MostrarAbrir(void);                                                               // Funcion para mostrar el dialogo de abrir archvos
 void						MostrarAbrirDirs(void);                                                               // Funcion para mostrar el dialogo de abrir archvos
 void                       Escanear(const TCHAR *Path);
 void						LVAgregar(const TCHAR *Path);                                                      // Funcion para aadir items al listview
 std::vector<DatosArchivo>  Archivos;                                                                         // Vector de archivos
 std::vector<DWL::DWLString>	Dirs;                                                                             // Vecto de directorios
 DWL::DWLString				AppPath;                                                                          // Path actual
 int						UltimClick;                                                                       // Ultimo item presionado
 bool						EjecutarExe;                                                                      // Ejecutable de despues de la instalacion
 DWL::DWLString               PathInicialDir;
 DWL::Controles::DWLListView              LV;
 DWL::Controles::DWLMenu					Menu;
 DWL::Controles::DWLEditBox				EditExe;
 DWL::Controles::DWLEditBox				EditExeSrc;
 DWL::Controles::DWLEditBox				EditPath;
 DWL::Controles::DWLComboBox				ComboBox;
// BOOL CALLBACK				GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);
};                                                                                                    //
